<?php

namespace Snapfile\Entities\User;

use Illuminate\Database\Eloquent\Model;

class ProfileData extends Model 
{

    protected $table = 'user_profile_data';
    public $timestamps = false;
    protected $fillable = array('user_profile_id', 'profile_field_id', 'value');
    protected $visible = array('user_profile_id', 'profile_field_id', 'value');

    public function profile()
    {
        return $this->belongsTo('Snapfile\Entities\User\Profile', 'user_profile_id');
    }

    public function field()
    {
        return $this->belongsTo('ProfileField', 'profile_field_id');
    }

}